/*
 * Decompiled with CFR 0.152.
 */
package com.whatsapp.api.ui;

import com.whatsapp.api.ui.Rect;
import com.whatsapp.api.ui.UIField;
import com.whatsapp.api.ui.UIManager;
import javax.microedition.lcdui.Graphics;

public class FieldManager
extends UIManager {
    public static final int SCROLL_BAR_WIDTH = 4;
    public static final int COLOR_ARROW = 553152;
    public static final int COLOR_SCROLL_BAR = 0xB0B0B0;
    public static final int COLOR_SCROLLER = 0x606460;
    private final boolean vert;
    private UIField _shadowFocus;

    public FieldManager(long style, boolean vert) {
        super(style);
        this.vert = vert;
    }

    public void sublayout(int realWidth, int realHeight) {
        int horiz = this.vert ? 0 : 1;
        int top = 0 + horiz;
        int left = 1 + horiz;
        int bottom = 2 + horiz;
        int right = (3 + horiz) % 4;
        int width = horiz;
        int height = 1 - horiz;
        int x = horiz;
        int y = 1 - horiz;
        int[] pad = new int[]{this.getPaddingTop(), this.getPaddingLeft(), this.getPaddingBottom(), this.getPaddingRight()};
        int[] size = new int[]{realWidth, realHeight};
        boolean reverse = this.getStyleBit(32L);
        boolean scroll = this.getStyleBit(16L);
        boolean vExpand = this.getStyleBit(this.vert ? 8L : 4L);
        boolean hCollapse = !this.getStyleBit(this.vert ? 4L : 8L);
        int numFields = this.getNumChildren();
        int maxHeight = scroll ? Integer.MAX_VALUE : size[height];
        int runningHeight = pad[!reverse ? top : bottom];
        int runningWidth = 0;
        for (int i = 0; i < numFields; ++i) {
            UIField fld = this.getChildAt(i);
            int[] margin = new int[]{fld.getMarginTop(), fld.getMarginLeft(), fld.getMarginBottom(), fld.getMarginRight()};
            int[] layoutSize = new int[]{size[width] - (pad[left] + margin[left] + margin[right] + pad[right]), maxHeight - runningHeight - pad[!reverse ? bottom : top] - margin[bottom] - margin[top]};
            fld.layout(layoutSize[width], layoutSize[height]);
            int[] fldSize = new int[]{fld.getWidth(), fld.getHeight()};
            runningWidth = Math.max(runningWidth, fldSize[width] + margin[left] + margin[right]);
            runningHeight = Math.min(maxHeight, runningHeight + margin[top] + fldSize[height] + margin[bottom]);
        }
        int usedWidth = !hCollapse ? size[width] : Math.min(size[width], runningWidth += pad[left] + pad[right]);
        int usedHeight = !vExpand ? runningHeight : Math.max(size[height], runningHeight += pad[!reverse ? bottom : top]);
        int usedPhysicalHeight = Math.min(usedHeight, size[height]);
        runningHeight = pad[!reverse ? top : bottom];
        for (int i = 0; i < numFields; ++i) {
            UIField fld = this.getChildAt(i);
            int[] margin = new int[]{fld.getMarginTop(), fld.getMarginLeft(), fld.getMarginBottom(), fld.getMarginRight()};
            int[] fldSize = new int[]{fld.getWidth(), fld.getHeight()};
            int align = fld.getAlign();
            runningHeight = !reverse ? Math.min(maxHeight, runningHeight + margin[top]) : Math.min(maxHeight, runningHeight + margin[bottom] + fldSize[height]);
            int fldX = pad[left] + margin[left];
            int fldY = !reverse ? runningHeight : usedHeight - runningHeight;
            runningHeight = !reverse ? Math.min(maxHeight, runningHeight + fldSize[height] + margin[bottom]) : Math.min(maxHeight, runningHeight + margin[top]);
            int alignedX = (align & (this.vert ? 1 : 2)) != 0 ? (usedWidth + pad[left] - pad[right] - fldSize[width]) / 2 : ((align & (this.vert ? 8 : 32)) != 0 ? usedWidth - pad[left] - pad[right] - fldSize[height] : fldX);
            int[] mgrPos = new int[]{Math.max(fldX, alignedX), fldY};
            fld.setManagerPosition(mgrPos[x], mgrPos[y]);
        }
        int[] extent = new int[]{usedWidth, usedPhysicalHeight};
        this.setExtent(extent[width], extent[height]);
        int[] virtualExtent = new int[]{usedWidth, usedHeight};
        this.setVirtualExtent(virtualExtent[width], virtualExtent[height]);
    }

    public void paint(Graphics g, int givenX, int givenY, int givenWidth, int givenHeight) {
        int horiz;
        Rect clip = new Rect(g.getClipX(), g.getClipY(), g.getClipWidth(), g.getClipHeight());
        g.clipRect(givenX, givenY, givenWidth, givenHeight);
        int width = horiz = this.vert ? 0 : 1;
        int height = 1 - horiz;
        int realWidth = 0;
        int realHeight = 1;
        int x = horiz;
        int y = 1 - horiz;
        int realX = 0;
        int realY = 1;
        int[] pos = new int[]{givenX, givenY};
        int[] bounds = new int[]{givenWidth, givenHeight};
        int[] physicalSize = new int[]{this.getWidth(), this.getHeight()};
        int[] virtualSize = new int[]{this.getVirtualWidth(), this.getVirtualHeight()};
        int[] scroll = new int[]{this.getHorizontalScroll(), this.getVerticalScroll()};
        super.paint(g, pos[realX], pos[realY], bounds[realWidth], bounds[realHeight]);
        if (this.getStyleBit(2L) && physicalSize[height] < virtualSize[height]) {
            int[] scrollBarPos = new int[2];
            int[] scrollBarSize = new int[2];
            scrollBarPos[x] = pos[x] + physicalSize[width] - 4;
            scrollBarPos[y] = pos[y];
            scrollBarSize[width] = 4;
            scrollBarSize[height] = physicalSize[height];
            int[] scrollerPos = new int[2];
            int[] scrollerSize = new int[2];
            scrollerPos[x] = scrollBarPos[x];
            scrollerPos[y] = scrollBarPos[y] + scroll[y] * scrollBarSize[height] / virtualSize[height];
            scrollerSize[width] = scrollBarSize[width];
            scrollerSize[height] = physicalSize[height] * scrollBarSize[height] / virtualSize[height];
            g.setColor(0xB0B0B0);
            g.fillRect(scrollBarPos[realX], scrollBarPos[realY], scrollBarSize[realWidth], scrollBarSize[realHeight]);
            g.setColor(0x606460);
            g.fillRect(scrollerPos[realX], scrollerPos[realY], scrollerSize[realWidth], scrollerSize[realHeight]);
        }
        g.setClip(clip.x, clip.y, clip.width, clip.height);
    }

    public void snapDown(int height) {
        if (this.getVirtualHeight() > height) {
            this.setVerticalScroll(this.getVirtualHeight() - height);
        }
    }

    public boolean traverse(int dir) {
        boolean res;
        boolean bl = res = this.internalTraverse(dir) || !this.hasFocus() && this.getStyleBit(1L);
        if (!res) {
            this._shadowFocus = null;
        }
        this.setFocus(res);
        return res;
    }

    protected boolean internalTraverse(int dir) {
        int newIndex;
        boolean res;
        boolean reversed = this.getStyleBit(32L);
        if (this.getNumChildren() == 0) {
            return false;
        }
        if (this.getNumChildren() == 1) {
            this._shadowFocus = this.getChildAt(0);
            return this._shadowFocus.traverse(dir);
        }
        if (this._shadowFocus == null) {
            this._shadowFocus = dir == 1 || dir == 2 ? this.getChildAt(!reversed ? this.getNumChildren() - 1 : 0) : this.getChildAt(!reversed ? 0 : this.getNumChildren() - 1);
        }
        if (res = this._shadowFocus.traverse(dir)) {
            return true;
        }
        int focusIndex = this.getChildIndex(this._shadowFocus);
        if (dir == 1) {
            newIndex = focusIndex + (!reversed ? -1 : 1);
        } else if (dir == 6) {
            newIndex = focusIndex + (!reversed ? 1 : -1);
        } else {
            return true;
        }
        if (newIndex < 0 || newIndex >= this.getNumChildren()) {
            return false;
        }
        this._shadowFocus = this.getChildAt(newIndex);
        return this.internalTraverse(dir);
    }

    public void traverseOut() {
        this.traverseOut(true);
    }

    public void traverseOut(boolean keepShadow) {
        if (this.hasFocus()) {
            if (this.getNumChildren() == 1) {
                this.getChildAt(0).traverseOut();
            } else if (this._shadowFocus != null) {
                this._shadowFocus.traverseOut();
                if (!keepShadow) {
                    this._shadowFocus = null;
                }
            }
            this.setFocus(false);
        }
    }

    public void moveFocus(UIField child) {
        if (this.getChildIndex(child) == -1) {
            throw new IllegalArgumentException("not my child");
        }
        if (this._shadowFocus != child && this._shadowFocus != null) {
            this._shadowFocus.traverseOut();
        }
        this._shadowFocus = child;
        child.traverse(0);
    }

    public UIField getFocus() {
        return this._shadowFocus;
    }
}

