/*
 * Decompiled with CFR 0.152.
 */
package com.whatsapp.api.ui;

import com.whatsapp.api.ui.TextUtils;
import com.whatsapp.api.ui.UIField;
import com.whatsapp.api.util.Utilities;
import java.util.Vector;
import javax.microedition.lcdui.Font;
import javax.microedition.lcdui.Graphics;

public class EmojiTextField
extends UIField {
    private static final int COLOR_LINK = 255;
    private static final int COLOR_FOCUSED_BACKGROUND = 0x99CCFF;
    private final Font _font;
    private final int _fontHeight;
    private final int _color;
    private String _textbuf;
    private Vector _laidOutText;
    private int _previousWidth = -1;

    public EmojiTextField(String s) {
        this(s, Font.getFont((int)0));
    }

    public EmojiTextField(String s, Font font) {
        this(s, font, 0);
    }

    public EmojiTextField(String s, Font font, int color) {
        super(0L);
        this._textbuf = s;
        this._font = font;
        this._fontHeight = this._font.getHeight();
        this._color = color;
    }

    public void setText(String s) {
        this._textbuf = s;
        this._laidOutText = null;
        this._previousWidth = -1;
    }

    public void paint(Graphics g, int x, int y, int width, int height) {
        if (this._laidOutText == null) {
            Utilities.logData("ui/emoji-text-field/paint/not-laid-out!");
            return;
        }
        if (this.hasFocus()) {
            g.setColor(0x99CCFF);
            g.fillRect(x, y, this.getWidth(), this.getHeight());
        }
        if (this.hasFieldCommands()) {
            g.setColor(255);
        } else {
            g.setColor(this._color);
        }
        g.setFont(this._font);
        for (int i = 0; i < this._laidOutText.size(); ++i) {
            String s = (String)this._laidOutText.elementAt(i);
            g.drawString(s, x, y + i * this._fontHeight, 20);
        }
    }

    public void layout(int width, int height) {
        if (this._previousWidth == width) {
            return;
        }
        this._laidOutText = TextUtils.simpleWrap(this._font, this._textbuf, width);
        int usedHeight = this._laidOutText.size() * this._fontHeight;
        this.setExtent(width, usedHeight);
        this._previousWidth = width;
    }
}

