/*
 * Decompiled with CFR 0.152.
 */
package com.whatsapp.api.ui;

import com.nokia.mid.ui.DirectUtils;
import com.whatsapp.api.ui.Command;
import com.whatsapp.api.ui.MenuCommand;
import com.whatsapp.api.ui.UIField;
import com.whatsapp.api.ui.UIOverlay;
import com.whatsapp.api.util.GraphicsUtils;
import com.whatsapp.client.Res;
import javax.microedition.lcdui.Canvas;
import javax.microedition.lcdui.Font;
import javax.microedition.lcdui.Graphics;

public class CommandBarField
extends UIField
implements UIOverlay {
    private static final int BOTTOM_PADDING = 1;
    public static final int H_PADDING = 4;
    private static final int MENU_OFFSET = 5;
    public static final int COLOR_BEHIND = 0x60000000;
    public static final int COLOR_BACKGROUND_GRAD_START = 0xA0A4A0;
    public static final int COLOR_BACKGROUND_GRAD_END = 0xF0F4F0;
    public static final int COLOR_BORDER = 0xA0A0A0;
    public static final int COLOR_TEXT = 0;
    private static final Font commandFont = Font.getFont((int)0, (int)1, (int)8);
    private static final int[] SOFT_KEY_CODE = new int[]{-6, -7, -5};
    private static final int[] SOFT_KEY_HALIGN = new int[]{4, 8, 1};
    public final MenuCommand optionsCmd = new MenuCommand(Res.getString(111), Command.OPTIONS, 0);
    public final Command menuCloseCmd = new Command(Res.getString(63), Command.BACK, 0);
    public final Command menuOpenCmd = new Command(Res.getString(144), Command.OK, 0);
    private final Command[] mainSoftKeyCmd = new Command[]{null, null, null};
    private final Command[] menuSoftKeyCmd = new Command[]{null, this.menuCloseCmd, this.menuOpenCmd};
    private Command[] curSoftKeyCmd = this.mainSoftKeyCmd;
    private Command menu = null;
    private int width;
    private int height;
    private Canvas parent = null;
    private Command.Listener listener = null;

    public CommandBarField() {
        super(0L);
        this.optionsCmd.setParentCommandBar(this);
    }

    public void setParent(Canvas parent) {
        this.parent = parent;
        this.optionsCmd.setParent(parent);
    }

    public boolean keyPressed(int keycode) {
        if (this.hasFocus() && this.menu != null && this.getMenu().keyPressed(this.menu, keycode)) {
            return true;
        }
        for (int i = 0; i < SOFT_KEY_CODE.length; ++i) {
            if (keycode != SOFT_KEY_CODE[i]) continue;
            Command cmd = this.curSoftKeyCmd[i];
            if (cmd != null && cmd.isEnabled()) {
                if (cmd.getBaseCommand() instanceof MenuCommand) {
                    this.showMenu(cmd);
                } else if (cmd == this.menuCloseCmd) {
                    this.hideMenu();
                    return true;
                }
                this.callCommandListener(cmd);
            }
            return true;
        }
        return this.hasFocus();
    }

    private MenuCommand getMenu() {
        return (MenuCommand)this.menu.getBaseCommand();
    }

    private void showMenu(Command menu) {
        if (this.menu != null) {
            this.hideMenu();
        }
        this.menu = menu;
        if (this.getMenu().show()) {
            this.curSoftKeyCmd = this.menuSoftKeyCmd;
            this.setFocus(true);
            this.layoutOverlay(this.width, this.height);
            this.repaint();
        } else {
            this.menu = null;
        }
    }

    void hideMenu() {
        if (this.menu != null) {
            this.getMenu().hide();
        }
        this.menu = null;
        this.curSoftKeyCmd = this.mainSoftKeyCmd;
        this.setFocus(false);
        this.repaint();
        this.callCommandListener(this.menuCloseCmd);
    }

    public void addCommand(Command cmd) {
        this.addCommand(cmd, false);
    }

    public void addCommand(Command cmd, boolean forceServeFirst) {
        Command cmpCmd;
        int cmp;
        int i;
        int softKey = cmd.commandType.softKey;
        if (cmd.getBaseCommand() instanceof MenuCommand) {
            ((MenuCommand)cmd.getBaseCommand()).setParentCommandBar(this);
        }
        this.repaint();
        Command otherCmd = this.mainSoftKeyCmd[softKey];
        if (otherCmd == null || otherCmd == cmd) {
            this.mainSoftKeyCmd[softKey] = cmd;
            return;
        }
        if (cmd.compareTo(otherCmd) > 0) {
            this.mainSoftKeyCmd[softKey] = cmd;
            this.addCommand(otherCmd, true);
            return;
        }
        for (i = 0; !(i >= this.optionsCmd.cmdList.size() || (cmp = cmd.compareTo(cmpCmd = (Command)this.optionsCmd.cmdList.elementAt(i))) > 0 || forceServeFirst && cmp == 0); ++i) {
            if (cmd != cmpCmd) continue;
            return;
        }
        this.optionsCmd.insertCommandAt(cmd, i);
        this.updateOptionsCmd();
    }

    public void removeCommand(Command cmd) {
        int softKey = cmd.commandType.softKey;
        this.repaint();
        if (this.mainSoftKeyCmd[softKey] != cmd) {
            if (this.optionsCmd.removeCommand(cmd)) {
                this.updateOptionsCmd();
            }
            return;
        }
        for (int i = 0; i < this.optionsCmd.cmdList.size(); ++i) {
            Command otherCmd = (Command)this.optionsCmd.cmdList.elementAt(i);
            int otherSoftKey = otherCmd.commandType.softKey;
            if (otherSoftKey != softKey) continue;
            this.optionsCmd.removeCommandAt(i);
            this.updateOptionsCmd();
            this.mainSoftKeyCmd[softKey] = otherCmd;
            this.layoutOverlay(this.width, this.height);
            return;
        }
        this.mainSoftKeyCmd[softKey] = null;
    }

    private void updateOptionsCmd() {
        int cmdCount = this.optionsCmd.cmdList.size();
        if (cmdCount == 0 || cmdCount == 1 && ((Command)this.optionsCmd.cmdList.elementAt((int)0)).commandType.softKey == this.optionsCmd.commandType.softKey) {
            this.removeCommand(this.optionsCmd);
        } else {
            this.addCommand(this.optionsCmd);
        }
    }

    public void setCommandListener(Command.Listener listener) {
        this.listener = listener;
    }

    boolean callCommandListener(Command c) {
        Command.Listener listener = this.listener;
        if (listener != null) {
            if (c instanceof UIField.FieldCommand) {
                UIField.FieldCommand fieldCmd = (UIField.FieldCommand)c;
                if (fieldCmd.callFieldCommandListener(fieldCmd.getBaseCommand())) {
                    return true;
                }
                return listener.commandAction(fieldCmd.cmd, fieldCmd.getParent());
            }
            return listener.commandAction(c, this);
        }
        return false;
    }

    public void layout(int width, int height) {
        this.setExtent(width, Math.min(commandFont.getHeight() + 1, height));
    }

    public void layoutOverlay(int width, int height) {
        this.width = width;
        this.height = height;
        if (this.menu == null) {
            return;
        }
        this.getMenu().layout(width, height);
    }

    public void repaint() {
        if (this.parent != null) {
            this.parent.repaint();
        }
    }

    public void paint(Graphics g, int x, int y, int width, int height) {
        int cmdBarX = x;
        int cmdBarY = y;
        int cmdBarWidth = width;
        int cmdBarHeight = height;
        g.setColor(0xA0A4A0);
        g.fillRect(cmdBarX, cmdBarY, cmdBarWidth, cmdBarHeight);
        GraphicsUtils.drawGradient(g, true, false, 0xF0F4F0, 0xA0A4A0, cmdBarX, cmdBarY, cmdBarWidth, cmdBarHeight / 2);
        g.setColor(0xA0A0A0);
        g.drawRect(cmdBarX, cmdBarY, cmdBarWidth - 1, cmdBarHeight - 1);
        g.setColor(0);
        Font origFont = g.getFont();
        g.setFont(commandFont);
        for (int i = 0; i < this.curSoftKeyCmd.length; ++i) {
            Command cmd = this.curSoftKeyCmd[i];
            if (cmd == null || cmd.label == null || !cmd.isEnabled()) continue;
            int softKeyHAlign = SOFT_KEY_HALIGN[i];
            int softKeyX = cmdBarX + 4;
            switch (softKeyHAlign) {
                case 8: {
                    softKeyX += cmdBarWidth / 2 - 4;
                }
                case 1: {
                    softKeyX += cmdBarWidth / 2 - 4;
                }
            }
            g.drawString(cmd.label, softKeyX, cmdBarY, softKeyHAlign | 0x10);
        }
        g.setFont(origFont);
    }

    public void paintOverlay(Graphics g, int x, int y, int width, int height) {
        if (this.menu == null) {
            return;
        }
        DirectUtils.getDirectGraphics((Graphics)g).setARGBColor(0x60000000);
        g.fillRect(x, y, width, height -= this.getHeight());
        this.getMenu().paint(g, x + 5, height, width - 5, height);
    }
}

