/*
 * Decompiled with CFR 0.152.
 */
package com.whatsapp.api.sapi;

import com.nokia.mid.s40.codec.DataDecoder;
import com.nokia.mid.s40.codec.DataEncoder;
import com.nokia.mid.s40.io.LocalMessageProtocolConnection;
import com.whatsapp.api.sapi.LocalSAPIMessageListener;
import com.whatsapp.api.util.SafeThread;
import com.whatsapp.api.util.Utilities;
import java.io.IOException;

class SAPIClient {
    private LocalSAPIMessageListener listener;
    private LocalMessageProtocolConnection connection;
    private boolean protocolNegotiated = false;
    private String version = "";
    private int byteSize = 500;
    private boolean receiving = false;
    private boolean protocolNegotiationFailed = false;
    private boolean closed = false;

    public SAPIClient(LocalMessageProtocolConnection con, LocalSAPIMessageListener listr, String version, int bytesize) {
        if (con == null) {
            throw new IllegalArgumentException("Connection can't be null");
        }
        if (listr == null) {
            throw new IllegalArgumentException("LocalSAPIMessageListener can't be null");
        }
        this.byteSize = bytesize;
        this.listener = listr;
        this.connection = con;
        this.startReceiving();
        this.negotiateVersion(version);
        Utilities.logData("SAPIClient created");
    }

    public synchronized void sendData(byte[] data) {
        if (this.connection != null) {
            try {
                this.connection.send(data, 0, data.length);
            }
            catch (IOException ex) {
                this.closeSafely(-2);
            }
        }
    }

    public synchronized void close() {
        this.closeSafely(0);
    }

    private void startReceiving() {
        SafeThread listeningThread = new SafeThread("SAPIClient"){

            public void safeRun() {
                LocalMessageProtocolConnection lConnection = SAPIClient.this.connection;
                LocalSAPIMessageListener lListener = SAPIClient.this.listener;
                if (lConnection == null) {
                    return;
                }
                try {
                    while (!SAPIClient.this.closed) {
                        SAPIClient.this.receiving = true;
                        byte[] data_in = new byte[SAPIClient.this.byteSize];
                        int data_size = lConnection.receive(data_in);
                        DataDecoder decoder = new DataDecoder("Conv-BEB", data_in, 0, data_size);
                        decoder.getStart(14);
                        String method = decoder.getString(13);
                        if (method.equals("Common")) {
                            SAPIClient.this.decodeCommonMessages(decoder, lListener);
                        } else {
                            lListener.localSAPIMessageReceived(method, decoder);
                        }
                        decoder = null;
                        data_in = null;
                        if (!SAPIClient.this.protocolNegotiationFailed) continue;
                        SAPIClient.this.closeSafely(-3);
                        break;
                    }
                }
                catch (Exception ex) {
                    SAPIClient.this.closeSafely(-1);
                }
                SAPIClient.this.receiving = false;
            }
        };
        listeningThread.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized void closeSafely(int reason) {
        this.receiving = false;
        if (this.connection != null) {
            try {
                this.connection.close();
            }
            catch (IOException iOException) {
            }
            finally {
                this.connection = null;
            }
        }
        if (this.listener != null) {
            this.listener.SAPIconnectionClosed(reason);
            this.listener = null;
        }
        this.closed = true;
        Utilities.logData("SAPI Connection Closed:" + reason);
    }

    private void decodeCommonMessages(DataDecoder decoder, LocalSAPIMessageListener curListener) throws IOException {
        String msg = "";
        if (decoder.getName().equals("message")) {
            decoder.getStart(14);
            String name = decoder.getString(13);
            msg = msg + name + ":" + decoder.getString(10);
            decoder.getEnd(14);
        }
        if (msg.startsWith("ProtocolVersion:")) {
            if (msg.indexOf(58) + 1 != -1) {
                this.version = msg.substring(msg.indexOf(58) + 1);
                if (this.version.length() > 0) {
                    this.protocolNegotiated = true;
                    Utilities.logData("ProtocolVersion:" + this.version);
                    curListener.SAPIready();
                } else {
                    this.protocolNegotiationFailed = true;
                }
            } else {
                this.protocolNegotiationFailed = true;
            }
        }
        curListener.commonSAPIMessageReceived(msg);
    }

    private void negotiateVersion(String version) {
        try {
            byte[] data_out = null;
            DataEncoder encoder = new DataEncoder("Conv-BEB");
            encoder.putStart(14, "event");
            encoder.put(13, "name", "Common");
            encoder.putStart(14, "message");
            encoder.put(13, "name", "ProtocolVersion");
            encoder.put(10, "version", version);
            encoder.putEnd(14, "message");
            encoder.putEnd(14, "event");
            data_out = encoder.getData();
            LocalMessageProtocolConnection lConnection = this.connection;
            if (data_out != null && lConnection != null) {
                lConnection.send(data_out, 0, data_out.length);
            }
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
    }

    public String getVersion() {
        return this.version;
    }
}

