/*
 * Decompiled with CFR 0.152.
 */
package com.whatsapp.api.sapi;

import com.nokia.mid.s40.codec.DataDecoder;
import com.nokia.mid.s40.codec.DataEncoder;
import com.nokia.mid.s40.io.LocalMessageProtocolConnection;
import com.whatsapp.api.sapi.LocalSAPIMessageListener;
import com.whatsapp.api.sapi.NMSListener;
import com.whatsapp.api.sapi.SAPIClient;
import com.whatsapp.api.util.Utilities;
import java.io.IOException;
import javax.microedition.io.Connector;

public class NMS
implements LocalSAPIMessageListener {
    private LocalMessageProtocolConnection nmsConnection;
    private String VERSION = "1.[0-10]";
    private String serverURL = "localmsg://nokia_email";
    private int byteSize = 500;
    private SAPIClient client;
    NMSListener listener;

    public NMS(NMSListener listr) {
        this.listener = listr;
    }

    public void connect() throws IOException {
        this.nmsConnection = (LocalMessageProtocolConnection)Connector.open((String)this.serverURL);
        this.client = new SAPIClient(this.nmsConnection, this, this.VERSION, this.byteSize);
    }

    public void closeConnection() {
        if (this.client != null) {
            this.client.close();
        }
    }

    private short composeEmail() {
        short transid = (short)System.currentTimeMillis();
        if (this.client != null) {
            try {
                byte[] data_out = null;
                DataEncoder encoder = new DataEncoder("Conv-BEB");
                encoder.putStart(14, "event");
                encoder.put(13, "name", "LaunchEmail");
                encoder.put(2, "trans_id", 5L);
                encoder.put(10, "launch_cookie", "");
                encoder.putEnd(14, "event");
                data_out = encoder.getData();
                if (data_out != null) {
                    this.client.sendData(data_out);
                }
                data_out = null;
                encoder = null;
            }
            catch (IOException ex) {
                ex.printStackTrace();
            }
        }
        return transid;
    }

    public short composeEmail(String to, String subject, String body, String[] attachmentPaths, String[] attachmentTypes, int numAttachments) {
        short transid = (short)System.currentTimeMillis();
        if (this.client != null) {
            try {
                byte[] data_out = null;
                DataEncoder encoder = new DataEncoder("Conv-BEB");
                encoder.putStart(14, "event");
                encoder.put(13, "name", "SendEmail");
                encoder.put(2, "trans_id", 5L);
                encoder.putStart(15, "email_info");
                encoder.put(10, "send_type", "New");
                encoder.put(11, "to_addresses", to);
                encoder.put(11, "subject", subject);
                encoder.put(11, "body", body);
                encoder.put(10, "interaction_type", "ShowComposer");
                if (attachmentPaths != null && numAttachments > 0) {
                    encoder.putStart(16, "attachment_paths");
                    for (int i = 0; i < numAttachments; ++i) {
                        encoder.putStart(14, "path_info");
                        encoder.put(11, "attachment_path", attachmentPaths[i]);
                        encoder.put(10, "attachment_type", attachmentTypes[i]);
                        encoder.putEnd(14, "path_info");
                        Utilities.logData("NMS attached file " + attachmentPaths[i]);
                    }
                    encoder.putEnd(16, "attachment_paths");
                }
                encoder.putEnd(15, "email_info");
                encoder.putEnd(14, "event");
                data_out = encoder.getData();
                if (data_out != null) {
                    this.client.sendData(data_out);
                }
                data_out = null;
                encoder = null;
            }
            catch (IOException ex) {
                ex.printStackTrace();
            }
        }
        return transid;
    }

    public void decodeComposeEmailResponse(DataDecoder decoder) throws IOException {
        short transid = (short)decoder.getInteger(5);
        String status = decoder.getString(10);
        if (!status.equals("Ok")) {
            this.listener.composeEmailFailed(transid, status);
        }
    }

    public void decodeEmailNotifyMessage(DataDecoder decoder) throws IOException {
        String status = decoder.getString(10);
        String exitCode = decoder.getString(10);
        this.listener.composerClosed(exitCode);
    }

    public void localSAPIMessageReceived(String method, DataDecoder decoder) {
        Utilities.logData("NMS method: " + method);
        String lowerMethod = method.toLowerCase();
        if (lowerMethod.equals("launchemail") || lowerMethod.equals("sendemail")) {
            try {
                this.decodeComposeEmailResponse(decoder);
            }
            catch (IOException ex) {
                ex.printStackTrace();
            }
        } else if (lowerMethod.equals("sendemailnotify")) {
            try {
                this.decodeEmailNotifyMessage(decoder);
            }
            catch (Throwable t) {
                Utilities.logData("blew up decoding sendemailnotify: " + t.toString());
            }
        } else {
            Utilities.logData("unhandled method in NMS: " + lowerMethod);
        }
    }

    public void SAPIconnectionClosed(int reason) {
        this.listener.NMSServerClosed(reason);
    }

    public void commonSAPIMessageReceived(String msg) {
        this.listener.NMSsystemMessageReceived(msg);
    }

    public void SAPIready() {
        this.listener.NMSServerReady();
    }
}

