/*
 * Decompiled with CFR 0.152.
 */
package com.whatsapp.api.contacts;

import com.whatsapp.api.contacts.ContactStatusDetails;
import com.whatsapp.api.util.Utilities;
import com.whatsapp.client.Constants;
import com.whatsapp.org.it.yup.xml.KXmlParser;
import com.whatsapp.org.xmlpull.v1.XmlPullParserException;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public abstract class Syncer
extends Thread {
    public static final byte SYNC_ERROR_OTHER = 0;
    public static final byte SYNC_ERROR_LOW_DISK_SPACE = 1;
    protected String _countryCode;
    protected String _phoneNumber;
    private static int _runningSyncs = 0;

    protected static synchronized void addRunningSync() {
        ++_runningSyncs;
    }

    protected static synchronized void stopRunningSync() {
        --_runningSyncs;
    }

    public static int getRunningSyncs() {
        return _runningSyncs;
    }

    public static String getUserAgent() {
        StringBuffer sb = new StringBuffer("WhatsApp/");
        sb.append(Utilities.getMidletVersion());
        sb.append(" S40Version/");
        String systemPlatform = System.getProperty("microedition.platform");
        int split = systemPlatform.indexOf(47);
        if (split > 0) {
            sb.append(systemPlatform.substring(split + 1));
            sb.append(" Device/");
            sb.append(systemPlatform.substring(0, split));
        } else {
            sb.append(systemPlatform);
            sb.append(" Device/");
            sb.append(systemPlatform);
        }
        return sb.toString();
    }

    protected static ContactStatusDetails parseXMLEntry(KXmlParser parser) throws XmlPullParserException, IOException {
        ContactStatusDetails res;
        long timeSinceSet;
        parser.require(2, null, "s");
        String phoneNumber = parser.getAttributeValue(null, "p");
        try {
            timeSinceSet = Long.parseLong(parser.getAttributeValue(null, "t"));
        }
        catch (Exception ex) {
            timeSinceSet = -1L;
        }
        String jid = parser.getAttributeValue(null, "jid");
        String unchatable = parser.getAttributeValue(null, "u");
        parser.nextToken();
        if (unchatable != null && unchatable.equals("1")) {
            res = new ContactStatusDetails(jid, phoneNumber, true);
        } else {
            String statusMessage = null;
            if (parser.getEventType() == 5) {
                parser.require(5, null, null);
                statusMessage = parser.getText();
                parser.nextTag();
            }
            if (statusMessage == null || statusMessage.length() == 0) {
                statusMessage = Constants.STRING_ONE_SPACE;
            }
            res = new ContactStatusDetails(statusMessage, timeSinceSet, jid, phoneNumber);
        }
        parser.require(3, null, "s");
        parser.nextTag();
        return res;
    }

    public static String readCRLFLine(InputStream in) throws IOException {
        StringBuffer sb = new StringBuffer();
        boolean crMode = false;
        while (true) {
            int curByte;
            if ((curByte = in.read()) == -1) {
                throw new IllegalStateException("stream end with no CRLF");
            }
            if (curByte == 13) {
                crMode = true;
                continue;
            }
            if (curByte == 10 && crMode) {
                return sb.toString();
            }
            if (crMode) {
                sb.append('\r');
                crMode = false;
            }
            sb.append((char)curByte);
        }
    }

    public static class UTF8URLEncoder {
        private static byte[] byteMap = new byte[]{48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 65, 66, 67, 68, 69, 70};

        private static byte[] urlencode(String s, boolean XMLValidate) {
            byte[] orig;
            try {
                orig = s.getBytes(Constants.CHARSET_UTF8);
            }
            catch (Exception x) {
                return null;
            }
            ByteArrayOutputStream baOS = new ByteArrayOutputStream(orig.length * 3);
            for (int i = 0; i < orig.length; ++i) {
                byte b = orig[i];
                if (b >= 48 && b <= 57 || b >= 65 && b <= 90 || b >= 97 && b <= 122 || b == 45 || b == 95 || b == 46) {
                    baOS.write(b);
                    continue;
                }
                if (b == 32) {
                    baOS.write(43);
                    continue;
                }
                if (XMLValidate && b < 32 && b != 9 && b != 10 && b != 13) {
                    return null;
                }
                baOS.write(37);
                baOS.write(byteMap[b >> 4]);
                baOS.write(byteMap[b % 16]);
            }
            try {
                baOS.flush();
                byte[] ret = baOS.toByteArray();
                baOS.close();
                return ret;
            }
            catch (Exception x) {
                return null;
            }
        }

        public static void appendPair(String key, String value, boolean xmlCheck, OutputStream os) throws IOException {
            byte[] vbytes = UTF8URLEncoder.urlencode(value, xmlCheck);
            if (vbytes == null) {
                return;
            }
            byte[] kbytes = UTF8URLEncoder.urlencode(key, false);
            os.write(kbytes);
            os.write(61);
            os.write(vbytes);
            os.write(38);
        }
    }

    public static class SyncerError
    extends Exception {
        public final byte errorCode;

        public SyncerError(byte code, String txt) {
            super(txt);
            this.errorCode = code;
        }
    }

    public static interface Listener {
        public void coldSyncFinished(long var1, boolean var3, boolean var4, byte var5, String var6);

        public void hotSyncFinished(long var1, boolean var3, Throwable var4);

        public void syncProgress(int var1);
    }
}

