/*
 * Decompiled with CFR 0.152.
 */
package com.whatsapp.api.contacts;

import com.whatsapp.api.contacts.Syncer;
import com.whatsapp.api.util.Utilities;
import com.whatsapp.client.Constants;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.util.Vector;
import javax.microedition.io.Connector;
import javax.microedition.io.SocketConnection;
import javax.microedition.io.file.FileConnection;

public class FileUploader
extends Thread {
    public static final int SPAN_PRE_SOCKET = 5;
    public static final int SPAN_SOCKET_CREATED = 10;
    public static final int SPAN_PRE_FILE = 10;
    public static final int SPAN_FILE_DATA = 70;
    public static final int SPAN_POST_PROC = 10;
    public static final int SPAN_CLEANUP = 5;
    public int _lastProgressSent = 0;
    private String _url;
    private String _hostname;
    private String _localAbsURL;
    private String _paramFilename;
    private String _localFilename;
    private String _contentType;
    private String[] _filePaths;
    private Vector _otherParams;
    private Vector _otherVals;
    private String _responseContentType;
    private long _totalFileSent = 0L;
    private long _totalFileSize = 0L;
    private boolean _chunked = false;
    private boolean _cancelled = false;

    public FileUploader(String URL2, String paramFilename, String localFilename, String contentType, String[] filePaths, Vector otherParams, Vector otherVals) {
        this._url = URL2;
        this._paramFilename = paramFilename;
        this._localFilename = localFilename;
        this._contentType = contentType;
        this._filePaths = filePaths;
        this._otherParams = otherParams;
        this._otherVals = otherVals;
    }

    public void addParamPair(String key, String value) {
        this._otherParams.addElement(key);
        this._otherVals.addElement(value);
    }

    public long getTotalFilesize() {
        return this._totalFileSize;
    }

    public String getResponseContentType() {
        return this._responseContentType;
    }

    public void setLocalFilename(String fname) {
        this._localFilename = fname;
    }

    protected static void writeBytes(OutputStream out, String s) throws IOException {
        out.write(s.getBytes());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void readFileToStream(OutputStream os, String filename, long expectedSize) throws IOException {
        long totalRead;
        block21: {
            FileConnection fileC = null;
            InputStream is = null;
            totalRead = 0L;
            try {
                int readBytes;
                fileC = (FileConnection)Connector.open((String)filename, (int)1);
                if (!fileC.exists() || fileC.fileSize() <= 0L) break block21;
                is = fileC.openInputStream();
                byte[] buf = new byte[1024];
                while (!this.isCancelled() && (readBytes = is.read(buf)) != -1) {
                    long expectedRemaining = expectedSize - totalRead;
                    totalRead += (long)readBytes;
                    this._totalFileSent += Math.min((long)readBytes, expectedRemaining);
                    if (expectedRemaining < (long)readBytes) {
                        os.write(buf, 0, (int)expectedRemaining);
                        break;
                    }
                    os.write(buf, 0, readBytes);
                    os.flush();
                    int newPercent = 10 + (int)(this._totalFileSent * 70L / this._totalFileSize);
                    if (newPercent <= this._lastProgressSent + 2) continue;
                    this.progress(newPercent);
                }
            }
            catch (Throwable t) {
                FileUploader.writeBytes(os, "****ERROR, sending anyway: " + t.toString() + "****");
                Utilities.logData("error reading file " + filename + " " + t.toString());
            }
            finally {
                if (is != null) {
                    try {
                        is.close();
                    }
                    catch (Exception x) {}
                }
                if (fileC != null) {
                    try {
                        fileC.close();
                    }
                    catch (Exception x) {}
                }
            }
        }
        Utilities.logData("upload read " + totalRead + ", expected " + expectedSize + " from file " + filename);
    }

    public int getHTTPResponseCode(InputStream is) throws IOException {
        String firstLine = Syncer.readCRLFLine(is);
        if (!firstLine.toUpperCase().startsWith("HTTP/1")) {
            throw new IllegalStateException("non-http response: " + firstLine);
        }
        int code = Integer.parseInt(firstLine.substring(9, 12));
        try {
            String headerLine;
            while ((headerLine = Syncer.readCRLFLine(is)).length() > 0) {
                if (headerLine.startsWith(Constants.HTTP_REQUEST_PROPERTY_CONTENT_TYPE)) {
                    this._responseContentType = headerLine.substring(headerLine.indexOf(32)).trim();
                    continue;
                }
                if (!headerLine.startsWith("Transfer-Encoding")) continue;
                String transEnc = headerLine.substring(headerLine.indexOf(32)).trim().toLowerCase();
                this._chunked = transEnc.equals("chunked");
            }
        }
        catch (Throwable t) {
            Utilities.logData("uploader blowup reading headers: " + t.toString());
        }
        return code;
    }

    public void handleResponseBody(Reader reader) {
    }

    public void progress(int percentComplete) {
        this._lastProgressSent = percentComplete;
    }

    public void finished(boolean success, String errorText) {
    }

    private SocketConnection makeConnection() throws IOException {
        int protoLength;
        boolean sslMode;
        if (this._url.startsWith(Constants.PROTOCOL_PREFIX_HTTPS)) {
            sslMode = true;
            protoLength = 8;
        } else if (this._url.startsWith(Constants.PROTOCOL_PREFIX_HTTP)) {
            sslMode = false;
            protoLength = 7;
        } else {
            throw new IllegalStateException("unknown URL type: " + this._url);
        }
        int nextSlash = this._url.indexOf(47, protoLength);
        this._hostname = this._url.substring(protoLength, nextSlash);
        this._localAbsURL = this._url.substring(nextSlash, this._url.length());
        String socketURL = sslMode ? Constants.PROTOCOL_PREFIX_SSL + this._hostname + ":443" : Constants.PROTOCOL_PREFIX_SOCKET + this._hostname + ":80";
        SocketConnection res = (SocketConnection)Connector.open((String)socketURL, (int)3, (boolean)true);
        res.setSocketOption((byte)0, 0);
        res.setSocketOption((byte)2, 1);
        res.setSocketOption((byte)1, 0);
        return res;
    }

    private void writeHTTPHeader(OutputStream os, String header, String val) throws IOException {
        os.write(header.getBytes());
        os.write(": ".getBytes());
        os.write(val.getBytes());
        os.write("\r\n".getBytes());
    }

    /*
     * Exception decompiling
     */
    public void run() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [8[TRYBLOCK]], but top level block is 83[FORLOOP]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public void cancel() {
        this._cancelled = true;
    }

    public boolean isCancelled() {
        return this._cancelled;
    }

    public static class UTF8ChunkStreamReader
    extends Reader {
        private static final int CLOSED = 0;
        private static final int NEEDS_CHUNK = 1;
        private static final int READING_DATA = 2;
        private static final int FINAL_CHUNK_SEEN = 3;
        private int _state = 1;
        private String _curDecodedData;
        private int _curDecodedDataIndex = 0;
        private InputStream _in;

        public UTF8ChunkStreamReader(InputStream in) throws IOException {
            this._in = in;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void getNextChunk() throws IOException {
            int curRead;
            String chunkLine = null;
            int chunkSize = 0;
            try {
                Thread.sleep(300L);
                chunkLine = Syncer.readCRLFLine(this._in);
                chunkSize = Integer.parseInt(chunkLine, 16);
                Thread.sleep(300L);
            }
            catch (Throwable t) {
                Utilities.logData("unchunker blew up reading chunk, stream dead");
                this._state = 0;
                return;
            }
            if (chunkSize == 0) {
                this._state = 3;
                return;
            }
            byte[] rawBytes = new byte[chunkSize];
            for (int rawRead = 0; rawRead < chunkSize; rawRead += curRead) {
                curRead = 0;
                try {
                    curRead = this._in.read(rawBytes, rawRead, chunkSize - rawRead);
                    continue;
                }
                catch (Throwable t) {
                    curRead = -1;
                }
                finally {
                    if (curRead == -1) {
                        Utilities.logData("expecting " + chunkSize + " bytes in chunk, stream died on " + rawRead);
                        this._state = 0;
                        return;
                    }
                }
            }
            try {
                this._curDecodedDataIndex = 0;
                this._curDecodedData = new String(rawBytes, Constants.CHARSET_UTF8);
                this._state = 2;
            }
            catch (Exception x) {
                throw new IOException("bad state in reader");
            }
        }

        public int read() throws IOException {
            if (this._state == 0 || this._state == 3) {
                return -1;
            }
            if (this._state == 1 || this._curDecodedDataIndex >= this._curDecodedData.length()) {
                this.getNextChunk();
                return this.read();
            }
            return this._curDecodedData.charAt(this._curDecodedDataIndex++);
        }

        public int read(char[] cbuf, int off, int len) throws IOException {
            if (this._state == 0 || this._state == 3) {
                return -1;
            }
            if (this._state == 1 || this._curDecodedDataIndex >= this._curDecodedData.length()) {
                this.getNextChunk();
                return this.read(cbuf, off, len);
            }
            int avail = this._curDecodedData.length() - this._curDecodedDataIndex;
            int useLen = avail > len ? len : avail;
            for (int i = 0; i < useLen; ++i) {
                cbuf[off + i] = this._curDecodedData.charAt(this._curDecodedDataIndex++);
            }
            return useLen;
        }

        public int read(char[] cbuf) throws IOException {
            return this.read(cbuf, 0, cbuf.length);
        }

        public long skip(long n) throws IOException {
            if (this._state == 0 || this._state == 3) {
                throw new IOException("reader closed");
            }
            if (this._state == 1 || this._curDecodedDataIndex >= this._curDecodedData.length()) {
                this.getNextChunk();
                return this.skip(n);
            }
            int avail = this._curDecodedData.length() - this._curDecodedDataIndex;
            if ((long)avail > n) {
                this._curDecodedDataIndex = (int)((long)this._curDecodedDataIndex + n);
                return n;
            }
            this._curDecodedDataIndex = this._curDecodedData.length();
            return avail;
        }

        public boolean ready() throws IOException {
            return this._curDecodedData != null && this._curDecodedDataIndex < this._curDecodedData.length() - 1 || this._in.available() > 0;
        }

        public boolean markSupported() {
            return false;
        }

        public void mark(int readAheadLimit) throws IOException {
            throw new UnsupportedOperationException();
        }

        public void close() throws IOException {
            this._state = 0;
            this._curDecodedData = null;
        }

        public void reset() throws IOException {
            throw new UnsupportedOperationException();
        }
    }
}

