/*
 * Decompiled with CFR 0.152.
 */
package com.whatsapp.api.contacts;

import com.whatsapp.api.util.AppManager;
import com.whatsapp.api.util.Sort;
import com.whatsapp.api.util.Utilities;
import com.whatsapp.client.Constants;
import com.whatsapp.client.FGApp;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.EOFException;
import java.io.FilterInputStream;
import java.io.FilterOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Hashtable;
import java.util.Vector;
import javax.microedition.io.Connector;
import javax.microedition.io.file.FileConnection;

public class Favorites {
    public static final int YES = 1;
    public static final int NO = 2;
    private static final String FILENAME = "WA_Favorites";
    Hashtable _favoritesTable = new Hashtable();
    Vector _favoritesList = new Vector();
    Vector _blackballList = new Vector();
    public boolean _dirty = false;

    private static String getPath() {
        return System.getProperty(Constants.PROPERTY_FILECONN_PRIVATE_DIR);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized boolean initialize() {
        FilterInputStream dIS;
        InputStream is;
        FileConnection fileC;
        block43: {
            boolean bl;
            block44: {
                fileC = null;
                is = null;
                dIS = null;
                this._favoritesList.removeAllElements();
                this._blackballList.removeAllElements();
                this._favoritesTable.clear();
                this._dirty = false;
                String filename = Favorites.getPath() + FILENAME;
                fileC = (FileConnection)Connector.open((String)filename, (int)1);
                if (fileC.exists()) break block43;
                bl = true;
                if (dIS == null) break block44;
                try {
                    dIS.close();
                }
                catch (Exception x) {
                    // empty catch block
                }
            }
            if (is != null) {
                try {
                    is.close();
                }
                catch (Exception x) {
                    // empty catch block
                }
            }
            if (fileC != null) {
                try {
                    fileC.close();
                }
                catch (Exception x) {
                    // empty catch block
                }
            }
            return bl;
        }
        try {
            is = fileC.openInputStream();
            dIS = new DataInputStream(is);
            try {
                while (true) {
                    String newJid = ((DataInputStream)dIS).readUTF();
                    int newVal = ((DataInputStream)dIS).readInt();
                    if (newVal == 1 || newVal == 2) {
                        this._favoritesTable.put(newJid, new Integer(newVal));
                        if (newVal == 1) {
                            this._favoritesList.addElement(newJid);
                            continue;
                        }
                        if (newVal != 2) continue;
                        this._blackballList.addElement(newJid);
                        continue;
                    }
                    Utilities.logData("stored Favorites jid " + newJid + " found with unknown val " + newVal);
                }
            }
            catch (EOFException x) {
                boolean bl = true;
                if (dIS != null) {
                    try {
                        dIS.close();
                    }
                    catch (Exception x2) {
                        // empty catch block
                    }
                }
                if (is != null) {
                    try {
                        is.close();
                    }
                    catch (Exception x3) {
                        // empty catch block
                    }
                }
                if (fileC != null) {
                    try {
                        fileC.close();
                    }
                    catch (Exception x4) {
                        // empty catch block
                    }
                }
                return bl;
            }
        }
        catch (Throwable t) {
            try {
                Utilities.logData("favs init blew up with " + t.toString());
                boolean bl = false;
                return bl;
            }
            catch (Throwable throwable) {
                throw throwable;
            }
            finally {
                if (dIS != null) {
                    try {
                        dIS.close();
                    }
                    catch (Exception x) {}
                }
                if (is != null) {
                    try {
                        is.close();
                    }
                    catch (Exception x) {}
                }
                if (fileC != null) {
                    try {
                        fileC.close();
                    }
                    catch (Exception x) {}
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void saveToDisk() {
        if (this._dirty) {
            FileConnection fileC = null;
            OutputStream os = null;
            FilterOutputStream dOS = null;
            try {
                String curJid;
                int i;
                String filename = Favorites.getPath() + FILENAME;
                fileC = (FileConnection)Connector.open((String)filename, (int)3);
                if (!fileC.exists()) {
                    fileC.create();
                }
                os = fileC.openOutputStream(0L);
                dOS = new DataOutputStream(os);
                for (i = 0; i < this._favoritesList.size(); ++i) {
                    curJid = (String)this._favoritesList.elementAt(i);
                    ((DataOutputStream)dOS).writeUTF(curJid);
                    ((DataOutputStream)dOS).writeInt(1);
                }
                Utilities.logData("stored total favs to disk: " + this._favoritesList.size());
                for (i = 0; i < this._blackballList.size(); ++i) {
                    curJid = (String)this._blackballList.elementAt(i);
                    ((DataOutputStream)dOS).writeUTF(curJid);
                    ((DataOutputStream)dOS).writeInt(2);
                }
                ((DataOutputStream)dOS).flush();
                this._dirty = false;
            }
            catch (Throwable t) {
                Utilities.logData("favorites save blew up with " + t.toString());
            }
            finally {
                if (dOS != null) {
                    try {
                        dOS.close();
                    }
                    catch (Exception x) {}
                }
                if (os != null) {
                    try {
                        os.close();
                    }
                    catch (Exception x) {}
                }
                if (fileC != null) {
                    try {
                        fileC.close();
                    }
                    catch (Exception x) {}
                }
            }
        } else {
            Utilities.logData("favs not dirty, no disk mod for total: " + this._favoritesList.size());
        }
    }

    public synchronized void addFavorite(String jid) {
        if (jid != null) {
            Integer curVal = (Integer)this._favoritesTable.get(jid);
            if (curVal == 1) {
                return;
            }
            this._dirty = true;
            this._favoritesList.addElement(jid);
            this._blackballList.removeElement(jid);
            this._favoritesTable.put(jid, new Integer(1));
        }
    }

    public synchronized void autoAdd(String jid) {
        Integer curVal = (Integer)this._favoritesTable.get(jid);
        if (curVal == null) {
            this._dirty = true;
            this._favoritesList.addElement(jid);
            this._favoritesTable.put(jid, new Integer(1));
        }
    }

    public boolean isFavorite(String jid) {
        Integer curVal = (Integer)this._favoritesTable.get(jid);
        return curVal != null && curVal == 1;
    }

    public synchronized void deleteFavorite(String jid, boolean blackball) {
        Utilities.logData("deleting favorite " + jid + " with blackball " + blackball);
        Object resObj = null;
        boolean res = this._favoritesList.removeElement(jid);
        if (blackball) {
            this._favoritesTable.put(jid, new Integer(2));
            this._blackballList.addElement(jid);
        } else {
            resObj = this._favoritesTable.remove(jid);
        }
        if (res || blackball || resObj != null) {
            this._dirty = true;
        }
    }

    public synchronized int moveFavorite(String jid, int delta) {
        int curIndex = this._favoritesList.indexOf(jid);
        int newIndex = curIndex + delta;
        if (curIndex < 0) {
            Utilities.logData(jid + " not found in stored favorites list!");
        }
        if (curIndex < 0 || newIndex < 0) {
            return 0;
        }
        if (newIndex > this._favoritesList.size()) {
            return curIndex;
        }
        this._favoritesList.removeElementAt(curIndex);
        this._favoritesList.insertElementAt(jid, newIndex);
        this._dirty = true;
        return newIndex;
    }

    public int size() {
        return this._favoritesList.size();
    }

    public Vector getList() {
        int s = this._favoritesList.size();
        Vector v = new Vector(this._favoritesList.size());
        for (int i = 0; i < s; ++i) {
            v.addElement(this._favoritesList.elementAt(i));
        }
        return v;
    }

    public synchronized void sort() {
        if (AppManager.isBackground()) {
            Utilities.logData("can't sort favs in bg");
            return;
        }
        if (this._favoritesList.size() > 1) {
            Vector newFavsList;
            this._favoritesList = newFavsList = Sort.quickSort(this._favoritesList, new Comparator());
            this._dirty = true;
        }
    }

    public static class Comparator
    implements Sort.Comparator {
        FGApp _fgApp = FGApp.getInstance();

        public int compare(Object o1, Object o2) {
            String jid1 = (String)o1;
            String jid2 = (String)o2;
            if (jid1 == null && jid2 != null) {
                return 1;
            }
            if (jid2 == null && jid1 != null) {
                return -1;
            }
            if (jid1 == null && jid2 == null) {
                return 0;
            }
            String name1 = this._fgApp.getDisplayableNameFromJid(jid1);
            String name2 = this._fgApp.getDisplayableNameFromJid(jid2);
            return name1.toUpperCase().compareTo(name2.toUpperCase());
        }
    }
}

