/*
 * Decompiled with CFR 0.152.
 */
package com.twistfuture.general;

import com.twistfuture.general.Button;
import com.twistfuture.general.GeneralFunction;
import com.twistfuture.readsms.MainMidlet;
import javax.microedition.io.ConnectionNotFoundException;
import javax.microedition.lcdui.Canvas;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;
import javax.microedition.midlet.MIDletStateChangeException;

public class FBLikeCanvas
extends Canvas
implements Button.Callback {
    Image mImage;
    Button mLikeButton;
    Button mCancelButton;
    final int LIKE_BUTTON;
    final int CANCEL_BUTTON;
    final int mMargin;
    int mCurrentButtonSelected = 0;
    public static final int KEY_UP = -1;
    public static final int KEY_DOWN = -2;
    public static final int KEY_LEFT = -3;
    public static final int KEY_RIGHT = -4;
    public static final int KEY_SELECT = -5;
    public static final int KEY_BACK = -6;
    public static final String mLikeURL = "https://www.facebook.com/pages/Twistfuture/306772299414140";

    public FBLikeCanvas() {
        this.LIKE_BUTTON = 1;
        this.CANCEL_BUTTON = 2;
        this.mMargin = 10;
        this.setFullScreenMode(true);
    }

    protected void showNotify() {
        this.mImage = GeneralFunction.createImage("fbimage/banner.png");
        this.mLikeButton = new Button(GeneralFunction.createImage("fbimage/like.png"), 10, 10, 1, this);
        this.mCancelButton = new Button(GeneralFunction.createImage("fbimage/exit.png"), 10, 10, 1, this);
        int x = (this.getWidth() - this.mLikeButton.getWidth()) / 2;
        int y = this.getHeight() - (this.mLikeButton.getHeight() + 10);
        this.mCancelButton.SetCordinate(x, y);
        this.mLikeButton.SetCordinate(x, y - (this.mLikeButton.getHeight() + 10));
        MainMidlet.mMidlet.unregisterDown();
        MainMidlet.mMidlet.registerForUP(new MainMidlet.Callback(){

            public void callRepaint(int x, int y, int width, int height) {
                FBLikeCanvas.this.repaint();
            }
        });
    }

    protected void hideNotify() {
        this.mImage = null;
        this.mCancelButton = null;
        this.mLikeButton = null;
    }

    protected void paint(Graphics g) {
        g.drawImage(this.mImage, 0, 0, 0);
        this.mCancelButton.paint(g);
        this.mLikeButton.paint(g);
        if (!this.hasPointerEvents()) {
            g.setColor(0xFFFFFF);
            if (this.mCurrentButtonSelected == 0) {
                g.drawRect(this.mLikeButton.getX() - 2, this.mLikeButton.getY() - 2, this.mLikeButton.getWidth() + 4, this.mLikeButton.getHeight() + 4);
            } else {
                g.drawRect(this.mCancelButton.getX() - 2, this.mCancelButton.getY() - 2, this.mCancelButton.getWidth() + 4, this.mCancelButton.getHeight() + 4);
            }
        }
        MainMidlet.mMidlet.paintAd(g);
    }

    protected void pointerPressed(int x, int y) {
        if (this.mCancelButton.pointerPressed(x, y)) {
            try {
                MainMidlet.mMidlet.Close();
            }
            catch (MIDletStateChangeException ex) {
                ex.printStackTrace();
            }
        }
        if (this.mLikeButton.pointerPressed(x, y)) {
            try {
                String fburl = mLikeURL;
                MainMidlet.mMidlet.platformRequest(fburl);
            }
            catch (ConnectionNotFoundException ex) {
                ex.printStackTrace();
            }
        }
        MainMidlet.mMidlet.adClicked(x, y);
    }

    protected void keyPressed(int KeyCode) {
        super.keyPressed(KeyCode);
        if (KeyCode == -1) {
            --this.mCurrentButtonSelected;
            if (this.mCurrentButtonSelected < 0) {
                this.mCurrentButtonSelected = 1;
            }
        }
        if (KeyCode == -2) {
            ++this.mCurrentButtonSelected;
            if (this.mCurrentButtonSelected > 1) {
                this.mCurrentButtonSelected = 0;
            }
        }
        if (KeyCode == -5) {
            this.buttonClicked(this.mCurrentButtonSelected + 1);
        }
        this.repaint();
    }

    public void areaToRepaint(int xcordi, int ycordi, int width, int height) {
        this.repaint(xcordi, ycordi, width, height);
    }

    public void buttonClicked(int buttonId) {
        switch (buttonId) {
            case 1: {
                try {
                    MainMidlet.mMidlet.platformRequest(mLikeURL);
                }
                catch (ConnectionNotFoundException ex) {
                    ex.printStackTrace();
                }
                break;
            }
            case 2: {
                try {
                    MainMidlet.mMidlet.Close();
                    break;
                }
                catch (MIDletStateChangeException ex) {
                    ex.printStackTrace();
                }
            }
        }
        this.repaint();
    }

    public void areaToBeRepaint(int xcordi, int ycordi, int width, int height) {
        this.repaint(xcordi, ycordi, width, height);
    }
}

