/*
 * Decompiled with CFR 0.152.
 */
package com.game.map;

import com.IScreen;
import com.MainCanvas;
import com.game.ManagerConture;
import com.game.rms.GameRms;
import com.game.shop.Shop;
import com.game.sprite.SpriteX;
import com.game.util.Graphics2D;
import com.game.util.Tools;
import com.menu.Menu;
import javax.microedition.lcdui.Image;

public class WorldMap
implements IScreen {
    private Image imgWorldMap = null;
    private SpriteX sprite = null;
    private SpriteX moveSprite = null;
    private int gameGateIndex = 0;
    private int[] mapPoint = new int[]{212, 209, 160, 211, 113, 211, 62, 185, 89, 155, 141, 148, 200, 151, 242, 145, 264, 113, 228, 88, 184, 83, 145, 80, 103, 82, 70, 80, 50, 52};
    public static int state = 0;
    private final int GAME_PAINT_MAP;
    private final int GAME_PAINT_SHOP;
    private Shop shop = null;
    private Image di = null;
    private Image guannumber = null;
    private Image guan = null;
    private Image mapBack = null;
    private Image mapEnter = null;

    public WorldMap(int guanka) {
        this.GAME_PAINT_MAP = 0;
        this.GAME_PAINT_SHOP = 1;
        MainCanvas.musicType = 1;
        this.gameGateIndex = guanka - 1;
    }

    public boolean inti(int num) {
        this.imgWorldMap = Tools.loadImage("/res/map/worldmap.png");
        this.sprite = new SpriteX("/res/map/point.sprite", Tools.loadImage("/res/map/point.png"));
        this.moveSprite = new SpriteX("/res/map/point.sprite", Tools.loadImage("/res/map/point.png"));
        this.moveSprite.setAction(6);
        this.di = Tools.loadImage("/res/map/di.png");
        this.guannumber = Tools.loadImage("/res/map/guannumber.png");
        this.guan = Tools.loadImage("/res/map/guan.png");
        this.mapBack = Tools.loadImage("/res/map/back.png");
        this.mapEnter = Tools.loadImage("/res/map/enter.png");
        return true;
    }

    public boolean keyPressedItem(int key) {
        if (state == 1) {
            this.shop.keyPressedItem(key);
        } else {
            switch (key) {
                case 15: {
                    if (this.gameGateIndex >= GameRms.rmsCurGate - 1) {
                        this.gameGateIndex = 0;
                        break;
                    }
                    ++this.gameGateIndex;
                    break;
                }
                case 16: {
                    if (this.gameGateIndex <= 0) {
                        this.gameGateIndex = GameRms.rmsCurGate - 1;
                        break;
                    }
                    --this.gameGateIndex;
                    break;
                }
                case 6: 
                case 17: 
                case 19: {
                    if (ManagerConture.isWuXian) {
                        MainCanvas.changeScreen(new ManagerConture());
                        break;
                    }
                    this.changeState(1);
                    ManagerConture.mCurGate = this.gameGateIndex + 1;
                    break;
                }
                case 18: {
                    ManagerConture.isWuXian = false;
                    MainCanvas.changeScreen(new Menu());
                }
            }
        }
        return true;
    }

    public boolean keyRepeatedItem(int key) {
        return true;
    }

    public boolean pointerPressedItem(int x, int y) {
        return true;
    }

    public void logic() {
    }

    public void paint(Graphics2D g) {
        switch (state) {
            case 0: {
                this.paintWorldMap(g);
                break;
            }
            case 1: {
                this.shop.paint(g);
            }
        }
    }

    private final void paintWorldMap(Graphics2D g) {
        g.drawImage(this.imgWorldMap, 0, 0, 0);
        for (int i = 0; i < 15; ++i) {
            if (i == 4) {
                this.sprite.setAction(1);
            } else if (i == 9) {
                this.sprite.setAction(3);
            } else if (i == 14) {
                this.sprite.setAction(5);
            } else if (i < 4) {
                this.sprite.setAction(0);
            } else if (i < 9) {
                this.sprite.setAction(2);
            } else if (i < 14) {
                this.sprite.setAction(4);
            }
            if (GameRms.rmsCurGate - 1 > i) {
                switch (i) {
                    case 4: 
                    case 9: 
                    case 14: {
                        this.sprite.setAction(8);
                        break;
                    }
                    default: {
                        this.sprite.setAction(7);
                    }
                }
            }
            this.sprite.setPosition(this.mapPoint[i * 2], this.mapPoint[i * 2 + 1]);
            this.sprite.paint(g);
        }
        this.moveSprite.setPosition(this.mapPoint[this.gameGateIndex * 2], this.mapPoint[this.gameGateIndex * 2 + 1]);
        this.moveSprite.paint(g);
        this.paintGuanKa(g, 70, 30);
        g.drawImage(this.mapEnter, 0, 240 - this.mapBack.getHeight(), 0);
        g.drawImage(this.mapBack, 320 - this.mapBack.getWidth(), 240 - this.mapBack.getHeight(), 0);
    }

    private final void changeState(int state) {
        switch (state) {
            case 1: {
                this.shop = new Shop();
                this.shop.inti();
                WorldMap.state = 1;
            }
        }
    }

    public void destroy() {
        this.imgWorldMap = null;
        this.sprite = null;
        this.moveSprite = null;
        state = 0;
    }

    private final void paintGuanKa(Graphics2D g, int x, int y) {
        if (this.gameGateIndex >= 0 && this.gameGateIndex <= 9) {
            g.drawImage(this.di, x, y, 0);
            x = x + this.di.getWidth() + 10;
            g.drawImageClip(this.guannumber, x, y, this.guannumber.getWidth() / 10, this.guannumber.getHeight(), 0, this.gameGateIndex, 0);
            x = x + this.guannumber.getWidth() / 10 + 10;
            g.drawImage(this.guan, x, y, 0);
        } else {
            g.drawImage(this.di, x, y, 0);
            x = x + this.di.getWidth() + 10;
            g.drawImageClip(this.guannumber, x, y, this.guannumber.getWidth() / 10, this.guannumber.getHeight(), 0, 9, 0);
            x = x + this.guannumber.getWidth() / 15 + 10;
            g.drawImageClip(this.guannumber, x, y, this.guannumber.getWidth() / 10, this.guannumber.getHeight(), 0, this.gameGateIndex - 10, 0);
            x = x + this.guannumber.getWidth() / 10 + 10;
            g.drawImage(this.guan, x, y, 0);
        }
    }
}

