/*
 * Decompiled with CFR 0.152.
 */
package com.game.film;

import com.MainCanvas;
import com.game.film.FilmScriptParse;
import com.game.map.WorldMap;
import com.game.rms.GameRms;
import com.game.util.Graphics2D;
import com.game.util.Tools;
import com.menu.Menu;
import java.io.IOException;
import javax.microedition.lcdui.Image;

public final class Film {
    private int logicState;
    private int paintState;
    private int color;
    private FilmScriptParse filmScript = null;
    private final int FILM_STATE_LOGIC;
    private final int FILM_STATE_ACTION;
    private final int FILM_STATE_PAINT;
    private final int FILM_STATE_NONE;
    private final int PAINT_SREEN_COLOR;
    private final int PAINT_SREEN_STRING;
    private final int PAINT_SCREEN_TALKFILM;
    private boolean filmEnd = false;
    public boolean istalkEnd = false;
    private int jianJu = 5;
    private int hangJu = 5;
    private int talkWidth = 300;
    private int talkHight = 230;
    private int indexChar = 0;
    private int hIndexChar = 0;
    private int strLenth = 0;
    private Image filmImage = null;
    private Image imgTiaoguo = null;

    public Film() {
        this.FILM_STATE_LOGIC = 0;
        this.FILM_STATE_ACTION = 1;
        this.FILM_STATE_PAINT = 2;
        this.FILM_STATE_NONE = 3;
        this.PAINT_SREEN_COLOR = 0;
        this.PAINT_SREEN_STRING = 1;
        this.PAINT_SCREEN_TALKFILM = 2;
    }

    public boolean isFilmEnd() {
        return this.filmEnd;
    }

    public void setFilmEnd(boolean filmEnd) {
        this.filmEnd = filmEnd;
    }

    public FilmScriptParse getFilmScript(String fileName) {
        this.filmScript = new FilmScriptParse();
        this.filmScript.loadFile("/res/script/" + fileName);
        try {
            this.filmScript.readFile();
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
        this.imgTiaoguo = Tools.loadImage("/res/map/tiaoguo.png");
        this.filmEnd = true;
        return this.filmScript;
    }

    public void setFilmScript(FilmScriptParse filmScript) {
        this.filmScript = filmScript;
    }

    public void logic() {
        if (!this.filmEnd) {
            return;
        }
        switch (this.logicState) {
            case 0: {
                if (this.filmScript.hasNext()) {
                    this.filmScript.readNextLine();
                    this.dealKey(this.filmScript.getKey());
                    break;
                }
                this.filmEnd = false;
                break;
            }
            case 1: {
                if (GameRms.rmsCurGate == 15) {
                    MainCanvas.changeScreen(new Menu());
                } else {
                    MainCanvas.changeScreen(new WorldMap(GameRms.rmsCurGate));
                }
                this.filmEnd = false;
                break;
            }
        }
    }

    public void paint(Graphics2D g) {
        if (!this.filmEnd) {
            return;
        }
        switch (this.paintState) {
            case 0: {
                g.setColor(0);
                g.fillRect(0, 0, 320, 240);
                break;
            }
            case 1: {
                g.setColor(this.color);
                g.fillRect(0, 0, 320, 240);
                g.setColor(16762624);
                if (!this.filmScript.getValue()[3].equals("null")) {
                    this.filmImage = Tools.loadImage("/res/script/" + this.filmScript.getValue()[5]);
                    g.drawImage(this.filmImage, Integer.parseInt(this.filmScript.getValue()[3]), Integer.parseInt(this.filmScript.getValue()[4]), 0);
                }
                this.drawString(g, this.filmScript.getValue()[2], Integer.parseInt(this.filmScript.getValue()[0]), Integer.parseInt(this.filmScript.getValue()[1]), this.hangJu, this.jianJu);
                g.drawImage(this.imgTiaoguo, 320 - this.imgTiaoguo.getWidth(), 240 - this.imgTiaoguo.getHeight(), 0);
                break;
            }
        }
    }

    private void dealKey(String keyStr) {
        if ("sreen_color".equals(keyStr)) {
            this.paintState = 0;
            this.color = Integer.parseInt(this.filmScript.getValue()[0].substring(2), 16);
        } else if ("drawString".equals(keyStr)) {
            this.paintState = 1;
            this.logicState = 3;
        } else if ("talkFilm".equals(keyStr)) {
            this.paintState = 2;
            this.logicState = 3;
        } else if ("nextScreen".equals(keyStr)) {
            this.logicState = 1;
            this.paintState = 0;
        }
    }

    public void keyPressed(int keyCode) {
        switch (keyCode) {
            case 18: {
                if (this.filmScript.hasNext()) {
                    this.getClass();
                    this.logicState = 0;
                }
                this.hIndexChar = 0;
                this.indexChar = 0;
                this.strLenth = 0;
                break;
            }
            case 19: {
                if (this.istalkEnd) {
                    this.getClass();
                    this.logicState = 0;
                    this.hIndexChar = 0;
                    this.indexChar = 0;
                    this.strLenth = 0;
                }
                this.indexChar = this.hIndexChar;
            }
        }
    }

    private void drawString(Graphics2D g, String talkStr, int x, int y, int hangJu, int jianJu) {
        x = 2;
        for (int i = this.indexChar; i < this.strLenth; ++i) {
            g.drawChar(talkStr.charAt(i), x += jianJu, y, 0);
            if ((x += MainCanvas.DEFAULFONT_WIDTH) >= this.talkWidth) {
                x = 2;
                y += MainCanvas.DEFAULFONT_HEIGHT + hangJu;
            }
            if (y <= this.talkHight) continue;
            this.hIndexChar = i + 1;
            return;
        }
        if (this.strLenth < talkStr.length()) {
            ++this.strLenth;
        }
        if (this.strLenth == talkStr.length()) {
            this.istalkEnd = true;
        }
    }

    public void destroy() {
        this.indexChar = 0;
        this.hIndexChar = 0;
        this.strLenth = 0;
        this.filmImage = null;
        this.filmScript = null;
        System.gc();
    }
}

