/*
 * Decompiled with CFR 0.152.
 */
package com.game.cannonball;

import com.game.cannonball.ICannonball;
import com.game.cannonball.RectCoordinate;
import com.game.monster.Monster;
import com.game.sprite.SpriteX;
import com.game.util.Graphics2D;
import javax.microedition.lcdui.Image;

public class CannonballMealie
extends SpriteX
implements ICannonball {
    private int hp;
    private int[] arrayInt = new int[]{-1, -1, -1, -1, -1, -1, -1, -1};
    private int speed;
    private int state;
    private int cannonballId;
    private RectCoordinate rect = null;

    public int getCannonballId() {
        return this.cannonballId;
    }

    public CannonballMealie(byte[] path, Image img, int id) {
        super(path, img);
        this.cannonballId = id;
        this.rect = new RectCoordinate();
        this.rect.setHeight(20);
        this.rect.setWidth(this.getWidth());
    }

    public void logic() {
        if (this.y <= -70) {
            this.state = 1;
            this.setVisible(false);
        }
        switch (this.state) {
            case 0: {
                this.move(0, -this.speed);
            }
        }
    }

    public final void paint(Graphics2D g) {
        super.paint(g);
    }

    public void setBallPosition(int x, int y) {
        this.setPosition(x, y);
    }

    public boolean collisionWithMonster(Monster monster, int monsterIndex) {
        this.rect.setX(this.getX() - this.getWidth() / 2);
        this.rect.setY(this.getY() - this.getHeight() / 2);
        if (!this.rect.collisionWithMonster(monster.getRect())) {
            return false;
        }
        for (int i = 0; i < this.arrayInt.length; ++i) {
            if (this.arrayInt[i] == monsterIndex) {
                return false;
            }
            if (this.arrayInt[i] != -1) continue;
            this.arrayInt[i] = monsterIndex;
            monster.changeState(4);
            monster.isDeath(this.hp);
            return false;
        }
        return true;
    }

    public void setState(int state) {
        this.state = state;
    }

    public int getState() {
        return this.state;
    }

    public void setSpeed(int speed) {
        this.speed = speed;
    }

    public void setHp(int hp) {
        this.hp = hp;
    }

    public int getHp() {
        return this.hp;
    }
}

